<?php

use App\Http\Controllers\Auth\AuthController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\LinksController;
use App\Http\Controllers\FlujoController;
use App\Http\Controllers\ParametrosController;
use App\Http\Controllers\EstadisticasController;
use App\Http\Controllers\Configuracion\EmpresasController;
use App\Http\Controllers\Configuracion\UsuariosController;
use App\Http\Controllers\Configuracion\RolesController;
use App\Http\Controllers\SoporteController;
use App\Http\Controllers\UbicacionController;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

/* Error Permiso Denegado */
Route::get('/error/403', function () {
    return view('errors.403');
})->name('error.403');

/* Authenticacion */
Route::get('/login', [AuthController::class, 'index'])->middleware('guest');;
Route::post('/login', [AuthController::class, 'login'])->name('login')->middleware('guest');;
Route::get('/logout', [AuthController::class, 'logout'])->name('logout');

/* Combos de ubicacion [Paises, Provincias, Partidos, Localidades] */
Route::get('/paises', [UbicacionController::class, 'getPaises']);
Route::get('/provincias/{pais_id}', [UbicacionController::class, 'getProvincias']);
Route::get('/partidos/{provincia_id}', [UbicacionController::class, 'getPartidos']);
Route::get('/localidades/{partido_id}', [UbicacionController::class, 'getLocalidades']);

Route::middleware(['auth', 'check.perms', 'locale'])->group(function (){
    
    /* Cambio de lenguaje */
    Route::get('/lang/{lang}', function ($lang) {
        session(['locale' => $lang]);
        return redirect()->back();
    });

    /* Panel de Control */
    Route::get('/', [DashboardController::class, 'index'])->name('panel');
    Route::get('/panel', [DashboardController::class, 'index'])->name('panel');

    /* Links de Utilidad */
    Route::get('/links/chatgpt', [LinksController::class, 'index'])->name('links.chatgpt');
    Route::get('/links/gemini', [LinksController::class, 'index'])->name('links.gemini');
    Route::get('/links/deepseek', [LinksController::class, 'index'])->name('links.deepseek');
    Route::get('/links/grok', [LinksController::class, 'index'])->name('links.grok');
    Route::get('/links/qwen', [LinksController::class, 'index'])->name('links.qwen');
    Route::get('/links/notebooklm', [LinksController::class, 'index'])->name('links.notebooklm');
    Route::get('/links/claude', [LinksController::class, 'index'])->name('links.claude');

    /* Flujo de Trabajo */
    Route::get('/flujo/procesar', [FlujoController::class, 'index'])->name('flujo.procesar');
    Route::get('/flujo/deletear', [FlujoController::class, 'index'])->name('flujo.deletear');

    /* Parametros */
    Route::get('/parametros', [ParametrosController::class, 'index'])->name('parametros');

    /* Estadisticas */
    Route::get('/estadisticas', [EstadisticasController::class, 'index'])->name('estadisticas');

    /* Configuracion - Cambio de Password */ 
    Route::get('/configuracion/password', [AuthController::class, 'formCambioPassword'])->name('configuracion.formpassword');
    Route::post('/configuracion/password', [AuthController::class, 'cambioPassword'])->name('configuracion.password');
    
    /* Configuracion - Empresas */
    Route::get('/configuracion/empresas', [EmpresasController::class, 'index'])->name('configuracion.empresas');
    Route::get('/configuracion/empresas/get', [EmpresasController::class, 'get'])->name('configuracion.empresas.get');
    Route::post('/configuracion/empresas/store', [EmpresasController::class, 'store'])->name('configuracion.empresas.store');;
    Route::get('/configuracion/empresas/edit/{idEmpresa}', [EmpresasController::class, 'edit'])->name('configuracion.empresas.edit');;
    Route::post('/configuracion/empresas/update', [EmpresasController::class, 'update'])->name('configuracion.usuarios.update');
    Route::get('/configuracion/empresas/destroy/{id}', [EmpresasController::class, 'destroy'])->name('configuracion.usuarios.destroy');
    
    /* Configuracion - Usuarios */
    Route::get('/configuracion/usuarios', [UsuariosController::class, 'index'])->name('configuracion.usuarios');
    Route::get('/configuracion/usuarios/get', [UsuariosController::class, 'get'])->name('configuracion.usuarios.get');
    Route::post('/configuracion/usuarios/store', [UsuariosController::class, 'store'])->name('configuracion.usuarios.store');;
    Route::get('/configuracion/usuarios/edit/{id}', [UsuariosController::class, 'edit'])->name('configuracion.usuarios.edit');;
    Route::post('/configuracion/usuarios/update', [UsuariosController::class, 'update'])->name('configuracion.usuarios.update');
    Route::get('/configuracion/usuarios/destroy/{id}', [UsuariosController::class, 'destroy'])->name('configuracion.usuarios.destroy');

    /* Configuracion - Roles y Permisos */
    Route::get('/configuracion/roles', [RolesController::class, 'index'])->name('configuracion.roles');
    Route::get('/configuracion/roles/get', [RolesController::class, 'get'])->name('configuracion.roles.get');
    Route::get('/configuracion/roles/create', [RolesController::class, 'create'])->name('configuracion.roles.create');
    Route::post('/configuracion/roles/store', [RolesController::class, 'store'])->name('configuracion.roles.store');
    Route::get('/configuracion/roles/edit/{id}', [RolesController::class, 'edit'])->name('configuracion.roles.edit');
    Route::post('/configuracion/roles/update', [RolesController::class, 'update'])->name('configuracion.roles.update');
    Route::post('/configuracion/roles/destroy/{id}', [RolesController::class, 'destroy'])->name('configuracion.roles.destroy');

    /* Soporte en Linea */
    Route::get('/soporte', [SoporteController::class, 'index'])->name('soporte');

});
