let dtEmpresas = null;

function cargarProvincias(idPais, idProvincia, idPartido, idLocalidad) {
    $.get(`${$urlBase}/provincias/${idPais}`, function (provincias) {
        let html = '<option value="">Seleccione...</option>';
        provincias.forEach(p => {
            html += `<option value="${p.id}" ${p.idProvincia == idProvincia ? 'selected' : ''}>${p.Descrip}</option>`;
        });
        $('#idProvincia').html(html);
        $('#idPais').val(idPais); 

        cargarPartidos(idProvincia, idPartido, idLocalidad);
    });
}

function cargarPartidos(idProvincia, idPartido, idLocalidad) {
    $.get(`${$urlBase}/partidos/${idProvincia}`, function (partidos) {
        let html = '<option value="">Seleccione...</option>';
        partidos.forEach(p => {
            html += `<option value="${p.id}" ${p.idPartido == idPartido ? 'selected' : ''}>${p.Descrip}</option>`;
        });
        $('#idPartido').html(html);

        cargarLocalidades(idPartido, idLocalidad);
    });
}

function cargarLocalidades(idPartido, idLocalidad) {
    $.get(`${$urlBase}/localidades/${idPartido}`, function (localidades) {
        let html = '<option value="">Seleccione...</option>';
        localidades.forEach(l => {
            html += `<option value="${l.id}" ${l.idLocalidad == idLocalidad ? 'selected' : ''}>${l.Descrip}</option>`;
        });
        $('#idLocalidad').html(html);
    });
}


let initDataTable = function () {
    dtEmpresas = $("#datatable").DataTable({
        dom: `
            <'row'<'col-sm-2'f><'col-sm-4'<"toolbar">><'col-sm-6'p>>
            <'row'<'col-sm-12't>>
            <'row'<'col-sm-5'i><'col-sm-7'p>>
        `,
        language: {
            url: '//cdn.datatables.net/plug-ins/1.10.21/i18n/Spanish.json'
        },
        serverSide: true,
        ajax: {
            url: $urlBase + "/configuracion/empresas/get",
            data: function (data){
                
            },
            dataType: "json"
        },
        pageLength: 50,
        columns: [{
            data: "idEmpresa",
            orderable: false,
                render: function(data, type, row, meta) {
                    if (type === "display") {
                        data = `<div class="custom-control custom-checkbox">
                            <input type="checkbox" class="custom-control-input dt-checkboxes">
                                <label class="custom-control-label">&nbsp;</label>
                            </div>`;
                    }
                    return data;
                },
                checkboxes: {
                    selectRow: true,
                    selectAllRender: `<div class="custom-control custom-checkbox">
                        <input type="checkbox" class="custom-control-input dt-checkboxes">
                            <label class="custom-control-label">&nbsp;</label>
                    </div>`
                }
            },
            { data: "RazonSocial", orderable: true, className: "text-left" },
            { data: "Email", orderable: true, className: "text-left" },
            { data: "Telefonos", orderable: true, className: "text-center" }
        ],
        columnDefs: [{
            title: "Accion",
            targets: 4,
            data: null,
            className: "text-center",
            defaultContent: `<div>
                <a href="javascript:void(0);" class="action-icon" id="btnEditar">
                    <i class="mdi mdi-square-edit-outline"></i>
                </a>
                <a href="javascript:void(0);" class="action-icon" id="btnEliminar">
                    <i class="mdi mdi-delete"></i>
                </a>
            </div>`
        }],
        select: {
            style: "multi"
        },
        order: [[1, "desc"]],
        drawCallback: function() {
            $(".dataTables_paginate > .pagination").addClass("pagination-rounded");
        },
        info: true,
        initComplete: function (){ }
    });

    $("#datatable tbody").on("click", "#btnEditar, #btnEliminar", function (){
        
        let oTable = $("#datatable").DataTable();
        var data = oTable.row($(this).parents('tr')).data();
        
        if(this.id == "btnEditar"){
            $.ajax({
                method: 'GET',
                url: $urlBase + `/configuracion/empresas/edit/${data.idEmpresa}`,
                contentType: false,
                processData: false,
                success: function (datos){

                    clearFormFields("form");
                    clearErrorMsg();

                    $("#idEmpresa").val(data.idEmpresa);
                    $("#RazonSocial").val(data.RazonSocial);
                    $("#NombreFantasia").val(data.NombreFantasia);
                    $("#Email").val(data.Email);
                    $("#Web").val(data.Web);
                    $("#Telefonos").val(data.Telefonos);
                    $("#Celular").val(data.Celular);
                    $("#idPais").val(data.IdPais);
                    $("#idProvincia").html('<option value=""></option>');
                    $("#idPartido").html('<option value=""></option>');
                    $("#idLocalidad").html('<option value=""></option>');
                    $("#CodigoPostal").val(data.CodigoPostal);
                    $("#Direccion").val(data.Direccion);
                    $("#Hab").val(data.Hab);

                    cargarProvincias(data.IdPais, data.IdProvincia, data.IdPartido, data.IdLocalidad);

                    $("#modalEmpresa").modal("show");
                    $("#modalEmpresa .modal-title").html(`Editar la Empresa [${data.idEmpresa}]`);
                    $(".modal-backdrop").css("zoom", "1.2");
                }
            });
        }

        if(this.id == "btnEliminar"){
            Swal.fire({
                title: "Confirmacion",
                text: "Seguro que desea inhabilitar la empresa: " + data.RazonSocial,
                type: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "SI",
                cancelButtonText: "NO"
              }).then(function (result) {
                if (result.value) {
                    $.ajax({
                        method: 'GET',
                        url: $urlBase + "/configuracion/empresas/destroy/" + data.idEmpresa,
                        success: function (response){
                            if(response.success){
                                Swal.fire({
                                    title: '',
                                    text: response.message,
                                    type: 'success',
                                    confirmButtonClass: 'btn btn-confirm mt-2'
                                });
                                $("#datatable").DataTable().draw();                    
                            }
                        }
                    });
                }
            });
        }
    });
}

function printErrorMsg (msg) {
    $(".print-error-msg").find("ul").html('');
    $(".print-error-msg").css('display','block');
    $.each( msg, function( key, value ) {
        $(".print-error-msg").find("ul").append('<li>'+value+'</li>');
    });
}

function clearErrorMsg () {
    $(".print-error-msg").find("ul").html('');
    $(".print-error-msg").css('display','none');
}

function clearFormFields(formId){
    document.querySelector(`#${formId}`).reset();
}

$(document).ready(function (){
   
    $('#idPais').on('change', function () {
        let paisId = $(this).val();
        $('#idProvincia').html('<option value="">Cargando...</option>');
        $.get($urlBase + '/provincias/' + paisId, function (data) {
            let options = '<option value="">Seleccione...</option>';
            data.forEach(function (provincia) {
                options += `<option value="${provincia.idProvincia}">${provincia.Descrip}</option>`;
            });
            $('#idProvincia').html(options);
            $('#idPartido').html('<option value="">Seleccione...</option>');
            $('#idLocalidad').html('<option value="">Seleccione...</option>');
        });
    });

    $('#idProvincia').on('change', function () {
        let provinciaId = $(this).val();
        $('#idPartido').html('<option value="">Cargando...</option>');
        $.get($urlBase + '/partidos/' + provinciaId, function (data) {
            let options = '<option value="">Seleccione...</option>';
            data.forEach(function (partido) {
                options += `<option value="${partido.idPartido}">${partido.Descrip}</option>`;
            });
            $('#idPartido').html(options);
            $('#idLocalidad').html('<option value="">Seleccione</option>');
        });
    });

    $('#idPartido').on('change', function () {
        let partidoId = $(this).val();
        $('#idLocalidad').html('<option value="">Cargando...</option>');
        $.get($urlBase + '/localidades/' + partidoId, function (data) {
            let options = '<option value="">Seleccione...</option>';
            data.forEach(function (localidad) {
                options += `<option value="${localidad.idLocalidad}">${localidad.Descrip}</option>`;
            });
            $('#idLocalidad').html(options);
        });
    });

    $("#btnNuevaEmpresa").on("click", function (e){
        $("#idEmpresa").val(0);
        $("#modalEmpresa").modal("show");
        $("#modalEmpresa .modal-title").html("Alta de Empresa");
        $(".modal-backdrop").css("zoom", "1.2");
        clearFormFields("form");
        clearErrorMsg();
    });
    
    $("#form").on("submit", function (e){
        e.preventDefault();
        
        let form = document.getElementById("form");
        let formData = new FormData(form);
        
        $.ajax({
            method: "POST",
            url: `${$urlBase}/configuracion/empresas/store`,
            data: formData,
            dataType: 'JSON',
            contentType: false,
            processData: false,
            beforeSend: function (){
                
            },
            success: function (response){
                if($.isEmptyObject(response.error)) {      
                    Swal.fire({
                        title: '',
                        text: response.message,
                        type: 'success',
                        confirmButtonClass: 'btn btn-confirm mt-2'
                    }).then(function (){
                        location.href = $urlBase + "/configuracion/empresas";
                    });
                }else{
                    console.log(response.error);
                    printErrorMsg(response.error);    
                }
            }
        });
    });
});