<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('con_usuarios', function (Blueprint $table) {
            $table->id();
            $table->string('idEmpresa', 6);
            $table->string('nombre', 20);
            $table->string('apellido', 20);
            $table->string('usuario', 40)->unique();
            $table->string('email', 100)->unique();
            $table->string('departamento', 50)->nullable();
            $table->string('telefonos', 60)->nullable();;
            //$table->timestamp('email_verified_at')->nullable();
            $table->string('clave', 256);
            $table->rememberToken();
            //$table->timestamps();
        });

        /*Schema::create('password_reset_tokens', function (Blueprint $table) {
            $table->string('email')->primary();
            $table->string('token');
            $table->timestamp('created_at')->nullable();
        });*/

        Schema::create('sessions', function (Blueprint $table) {
            $table->string('id')->primary();
            $table->foreignId('user_id')->nullable()->index();
            $table->string('ip_address', 45)->nullable();
            $table->text('user_agent')->nullable();
            $table->longText('payload');
            $table->integer('last_activity')->index();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('con_usuarios');
        //Schema::dropIfExists('password_reset_tokens');
        Schema::dropIfExists('sessions');
    }
};
