<?php 
namespace App\Providers;

use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class ViewServiceProvider extends ServiceProvider
{
    public function boot(): void
    {
        View::composer('*', function ($view) {
            if (Auth::check()) {
                $user = Auth::user();

                // Traer todos los permisos del usuario
                $permisos = DB::table('permissions')
                    ->select('id', 'name', 'parent', 'route', 'is_parent', 'is_executable', 'order', 'icon', 'target')
                    ->whereIn('id', function ($query) use ($user) {
                        $query->select('permission_id')
                            ->from('role_has_permissions')
                            ->whereIn('role_id', function ($q) use ($user) {
                                $q->select('role_id')
                                    ->from('model_has_roles')
                                    ->where('model_id', $user->id)
                                    ->where('model_type', get_class($user));
                            });
                    })
                    ->orderBy('order', 'ASC')
                    ->get();

                // Agrupar por padres
                $menu = [];

                foreach ($permisos as $permiso) {
                    if ($permiso->is_parent) {
                        $menu[$permiso->id] = [
                            'Descrip' => $permiso->name,
                            'ArchVinculacion' => $permiso->route,
                            'OpcionEjecutable' => $permiso->is_executable,
                            'Icono' => $permiso->icon, // Puedes usar otro campo si lo tenés
                            'order' => $permiso->order,
                            'target' => $permiso->target,
                            'hijas' => [],
                        ];
                    }
                }

                // Asignar hijos a los padres
                foreach ($permisos as $permiso) {
                    if (!$permiso->is_parent && $permiso->parent && isset($menu[$permiso->parent])) {
                        $menu[$permiso->parent]['hijas'][] = [
                            'Descrip' => $permiso->name,
                            'ArchVinculacion' => $permiso->route,
                            'OpcionEjecutable' => $permiso->is_executable,
                            'target' => $permiso->target,
                            'order' => $permiso->order,
                        ];
                    }

                    // Permisos que no tienen padre y son ejecutables (simples)
                    if (!$permiso->is_parent && is_null($permiso->parent)) {
                        $menu[$permiso->id] = [
                            'Descrip' => $permiso->name,
                            'ArchVinculacion' => $permiso->route,
                            'OpcionEjecutable' => $permiso->is_executable,
                            'Icono' => $permiso->icon,
                            'order' => $permiso->order,
                            'target' => $permiso->target,
                            'hijas' => [],
                        ];
                    }
                }

                // Ordenar padres y sus hijas por 'order'
                $menu = collect($menu)->sortBy('order')->map(function ($item) {
                    if (!empty($item['hijas'])) {
                        $item['hijas'] = collect($item['hijas'])
                            ->sortBy('order')
                            ->values()
                            ->toArray();
                    }
                    return $item;
                })->toArray();

                $view->with('sidebarPermisos', $menu);
            }
        });
    }

    public function register(): void
    {
        //
    }
}
