@extends("layout.app")

@section("content")
    <div class="container-fluid" id="bg-soporte">        
        <div class="pt-2 pb-3">
            <h4 class="text-center">{{Lang::get("support.titulo")}}</h4>
            <h3 class="text-center">{{Lang::get("support.subtitulo")}}</h3>
        </div>

        <div class="row">
            <div class="col-md-3 col-xs-12">
                <div class="card h-75 pb-2">
                    <div class="card-body text-primary">
                        <div class="media">
                            <img src="{{ asset('assets/images/1.png') }}" alt="" class="d-flex align-self-start mr-3" width="40"> 
                            <div class="media-body">
                                <p class="mb-1 text-dark">{{Lang::get("support.pasos.paso_1")}}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3 col-xs-12">
                <div class="card h-75">
                    <div class="card-body text-primary">
                        <div class="media">
                            <img src="{{ asset('assets/images/2.png') }}" alt="" class="d-flex align-self-start mr-3" width="50"> 
                            <div class="media-body">
                                <p class="mb-1 text-dark">{{Lang::get("support.pasos.paso_2")}}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3 col-xs-12">
                <div class="card h-75">
                    <div class="card-body text-primary">
                        <div class="media">
                            <img src="{{ asset('assets/images/3.png') }}" alt="" class="d-flex align-self-start mr-3" width="50"> 
                            <div class="media-body">
                                <p class="mb-1 text-dark">{{Lang::get("support.pasos.paso_3")}}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3 col-xs-12">
                <div class="card h-75">
                    <div class="card-body text-primary">
                        <div class="media">
                            <img src="{{ asset('assets/images/4.png') }}" alt="" class="d-flex align-self-start mr-3" width="50"> 
                            <div class="media-body">
                                <p class="mb-1 text-dark">{{Lang::get("support.pasos.paso_4")}}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <p class="text-center">
                    <a href="{{url('/soporte/download')}}" class="btn btn-success">
                        <i class="mdi mdi-cloud-download"></i> &nbsp;
                        {{ Lang::get('buttons.b_soporte.titulo') }}
                    </a>
                </p>
            </div>
        </div>
        <div class="row">    
            <div class="col-sm-12">   
                <h5 class="title text-center"><strong>{{Lang::get("support.preguntas.pregunta_1")}}</strong></h5>
                <p class="text-center">{{Lang::get("support.respuestas.respuesta_1")}}</p>
                <h5 class="title text-center"><strong>{{Lang::get("support.preguntas.pregunta_2")}}</strong></h5>
                <p class="text-center">{{Lang::get("support.respuestas.respuesta_1")}}</p>
            </div> 
        </div>
    </div>

@endsection


@section("script")

    <script>

        $(document).ready(function (){

            //background-image: url('http://estudioenfoco.com/assets/img/soporte2.jpg');

            let urlBackground = $urlBase + '/public/assets/images/bg-soporte.jpg';

            $(".content-page").css("background-image", "url("+urlBackground+")");
            
            $(".content-page").css("background-size", "cover");

            $(window).resize(function() {
                
                $(".content-page").css("background-image", "url("+urlBackground+")");
            
                $(".content-page").css("background-size", "cover");

            });

        });

    </script>

@endsection