@extends('layout.app')

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="{{ route('panel') }}">Panel de Control</a></li>
                            <li class="breadcrumb-item active">Usuarios</li>
                        </ol>
                    </div>
                    <h4 class="page-title ml-1">Usuarios</h4>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row mb-2">
                            <div class="col-sm-4">
                                
                            </div>
                            <div class="col-sm-8">
                                <div class="text-sm-right">
                                    <button class="btn btn-primary mb-2" id="btnNuevoUsuario">
                                        <i class="mdi mdi-plus-circle mr-2"></i> 
                                        Nuevo Usuario
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-centered table-striped dt-responsive w-100" id="datatable">
                                <thead>
                                    <tr>
                                        <th style="width: 20px;">
                                            <div class="custom-control custom-checkbox">
                                                <input type="checkbox" class="custom-control-input" id="customCheck1">
                                                <label class="custom-control-label" for="customCheck1">&nbsp;</label>
                                            </div>
                                        </th>
                                        <th>Nombre</th>
                                        <th>Apellido</th>
                                        <th>Tipo Usuario</th>
                                        <th>Email</th>
                                        <th>Telefonos</th>
                                        <th style="width: 75px;">Accion</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td class="text-center" colspan="5">
                                            No se encontraron registros
                                        </td>
                                    </tr>   
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @include('configuracion.usuarios.modal')

@endsection

@section('styles')
    
@endsection

@section('script')
    <script src="{{ asset('assets/js/app/configuracion/usuarios.js') }}"></script>
    <script>
        $(document).ready(function(){
            initDataTable();
        });
    </script>
@endsection