@extends('layout.app')

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="{{ url('/panel') }}">{{ Lang::get('labels.general.panel') }}</a></li>
                            <li class="breadcrumb-item active">{{ Lang::get('labels.settings.password.titulo') }}</li>
                        </ol>
                    </div>
                    <h4 class="page-title ml-1">{{ Lang::get('labels.settings.password.titulo') }}</h4>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <form id="form" action="/" method="POST">
                            @csrf
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="form-group mb-2">
                                        <label>{{ Lang::get('labels.settings.password.clave_actual') }}</label>
                                        <div class="input-group input-group-merge">
                                            <input type="password" id="ClaveActual" name="ClaveActual" class="form-control">
                                            <div class="input-group-append" data-password="false">
                                                <div class="input-group-text">
                                                    <span class="password-eye"></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group mb-2">
                                        <label>{{ Lang::get('labels.settings.password.clave_nueva_1') }}</label>
                                        <div class="input-group input-group-merge">
                                            <input type="password" id="ClaveNueva" name="ClaveNueva" class="form-control">
                                            <div class="input-group-append" data-password="false">
                                                <div class="input-group-text">
                                                    <span class="password-eye"></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group mb-2">
                                        <label>{{ Lang::get('labels.settings.password.clave_nueva_2') }}</label>
                                        <div class="input-group input-group-merge">
                                            <input type="password" id="ClaveNueva2" name="ClaveNueva2" class="form-control">
                                            <div class="input-group-append" data-password="false">
                                                <div class="input-group-text">
                                                    <span class="password-eye"></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group mt-3 mb-3">
                                        <div class="error-message">
                                            <div class="alert alert-danger text-center">
            
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-12">
                                    <button type="submit" class="btn btn-warning">{{ Lang::get('buttons.b_aceptar.titulo') }}</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script src="{{ asset('assets/js/app/configuracion/password.js') }}"></script>
    <script>
        password.init();
    </script>
@endsection