<!DOCTYPE html>
<html lang="es">
    <head>
        <meta charset="utf-8" />
        <title>VisualTienda | Inicio de Sesion</title>
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta content="A fully featured admin theme which can be used to build CRM, CMS, etc." name="description" />
        <meta content="Coderthemes" name="author" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <link rel="shortcut icon" href="{{ asset('assets/images/favicon.ico') }}">
        <link href="{{ asset('assets/libs/ladda/ladda-themeless.min.css') }}" rel="stylesheet">
		<link href="{{ asset('assets/css/bootstrap.min.css') }}" rel="stylesheet" type="text/css" id="bs-default-stylesheet" />
		<link href="{{ asset('assets/css/app.min.css') }}" rel="stylesheet" type="text/css" id="app-default-stylesheet" />
		<link href="{{ asset('assets/css/bootstrap-dark.min.css') }}" rel="stylesheet" type="text/css" id="bs-dark-stylesheet" />
		<link href="{{ asset('assets/css/app-dark.min.css') }}" rel="stylesheet" type="text/css" id="app-dark-stylesheet" />
        <link href="{{ asset('assets/css/icons.min.css') }}" rel="stylesheet" type="text/css" />
        <script>
            let $urlBase = "{{ URL::to('/') }}";
        </script>
        <style type="text/css">
            .has-error > span.help-block{
                color:#cf0000 !important;
            }
            .auth-brand {
                /*top: 1rem !important;*/
            }
            .error-login{
                display:none;
            }
            .btn-success{
                color: #fff !important;
                background-color: #ed7f06 !important;
                border-color: #ed7f06 !important;
            }
            .custom-control-input:checked~.custom-control-label::before{
                color: #fff !important;
                border-color: #ed7f06 !important;
                background-color: #ed7f06 !important;
            }
            .auth-fluid{
                background: url('{{ asset('assets/images/bg-olvido.jpg') }}') center !important;
                background-size:cover !important;
            }
        </style>
    </head>
    <body class="loading auth-fluid-pages pb-0">
        <div class="auth-fluid">
            <div class="auth-fluid-form-box">
                <div class="align-items-center d-flex h-100">
                    <div class="card-body">
                        <div class="auth-brand text-center text-lg-left">
                            <div class="auth-logo">
                                <a href="index.html" class="logo logo-dark text-center">
                                    <span class="logo-lg">
                                        <img src="{{ asset('assets/images/logo.png') }}" alt="" height="60">
                                    </span>
                                </a>
                                <a href="index.html" class="logo logo-light text-center">
                                    <span class="logo-lg">
                                        <img src="{{ asset('assets/images/logo.png') }}" alt="" height="22">
                                    </span>
                                </a>
                            </div>
                        </div>
                        <h4 class="mt-3">Inicio de sesion</h4>
                        <p class="text-muted mb-4">
                            A continuacion ingrese su Email y le enviaremos un correo con los pasos para 
                            crear un nuevo password.
                        </p>
                        <form id="form-olvido">
                            @csrf
                            <div class="form-group">
                                <label for="email">Email</label>
                                <input class="form-control" type="email" id="email" name="email" required="" placeholder="Ingrese su email" autocomplete="off">
                            </div>
                            <div class="error-login">
                                <div class="alert alert-danger text-center">

                                </div>
                            </div>
                            <div class="form-group mb-0 text-center">
                                <button class="ladda-button btn btn-success btn-block" id="btn-recuperar" dir="ltr" data-style="slide-down" type="submit">
                                    <span class="ladda-label"><strong>Reset Password</strong></span>
                                    <span class="ladda-spinner"></span>
                                    <div class="ladda-progress" style="width: 0px;"></div>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <script src="{{ asset('assets/js/vendor.min.js') }}"></script>
        <script src="{{ asset('assets/libs/ladda/spin.min.js') }}"></script>
        <script src="{{ asset('assets/libs/ladda/ladda.min.js') }}"></script>
        <script src="{{ asset('assets/js/pages/loading-btn.init.js') }}"></script>
        <script src="{{ asset('assets/js/app.min.js') }}"></script> 
        <script src="{{ asset('assets/js/app/auth/olvido.js') }}"></script>
    </body>
</html>