<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tip_localidad', function (Blueprint $table) {
            $table->string('idPais', 3)->comment('id Pais');
            $table->char('idProvincia', 3)->nullable();
            $table->integer('idPartido')->default(0);
            $table->integer('idLocalidad')->comment('idLocalidad');
            $table->char('Descrip', 60)->nullable();
            $table->boolean('Hab')->default(0);
            $table->string('CodPostal', 10)->nullable()->comment('Código Postal');
            $table->primary(['idPais', 'idLocalidad']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tip_localidad');
    }
};
