<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('mae_parametros', function (Blueprint $table) {
            $table->increments('Id');
            $table->integer('idEmpresa')->default(0)->comment('id Empresa');
            $table->string('ApiKey_Embedding', 255)->nullable()->comment('API KEY embedding');
            $table->string('Host_Embedding', 255)->nullable()->comment('Host embedding');
            $table->decimal('PuertoEmbedding', 6, 0)->unsigned()->default(0)->comment('Puerto para embedding');
            $table->string('usrEmbedding', 50)->nullable()->comment('Usuario Embedding');
            $table->string('pswEmbedding', 30)->nullable()->comment('Password Embedding');
            $table->decimal('idModeloEmbedding', 4, 0)->unsigned()->default(0)->comment('Modelo para Embedding');
            $table->string('NomColeccion', 50)->nullable()->comment('Nombre de la coleccion');
            $table->string('CarpetaDocumentos', 60)->nullable()->comment('Carpeta donde estan los documentos');
            $table->string('Tesseract_Path', 255)->nullable()->comment('Path donde se encuentra Tesseract');
            $table->decimal('EMBEDDING_DIMENSION', 6, 0)->unsigned()->nullable()->comment('Cantidad de dimensiones del modelo');
            $table->decimal('CHUNK_SIZE', 6, 0)->unsigned()->default(0)->comment('Chunk Size ver recomendaciones para el modelo');
            $table->decimal('CHUNK_OVERLAP', 6, 0)->unsigned()->default(0)->comment('CHUNK_OVERLAP recomendada para el modelo');
            $table->string('SUPPORTED_EXTENSIONS', 255)->nullable()->comment('Extensiones a procesar');
            $table->decimal('TOP_K', 3, 0)->unsigned()->default(0)->comment('Cantidad de fragmentos relevantes');
            $table->string('ApiKey_Consulta', 255)->nullable()->comment('API KEY Consulta');
            $table->string('Host_Consulta', 255)->nullable()->comment('Host Consulta');
            $table->decimal('PuertoConsulta', 6, 0)->unsigned()->default(0)->comment('Puerto para Consulta');
            $table->string('usrConsulta', 50)->nullable()->comment('Usuario Consulta');
            $table->string('pswConsulta', 30)->nullable()->comment('Password Consulta');
            $table->decimal('idModeloConsulta', 4, 0)->unsigned()->default(0)->comment('Modelo para Consulta');
            $table->binary('RolPrompting')->nullable()->comment('Descripcion del rol que queremos que cumpla');
            $table->binary('PerPrompting')->nullable()->comment('Tipo de personalidad y formas de respuesta que queremos que adopte');
            $table->string('WakeName', 20)->nullable()->comment('Nombre de IA o Asistente');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('mae_parametros');
    }
};
