<?php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable
{
    use HasRoles, HasFactory;

    protected $table = "con_usuarios";

    public $timestamps = false;

    protected $fillable = [
        'idEmpresa',
        'usuario',
        'departamento',
        'email',
        'telefonos',
        'clave',
    ];

    protected $hidden = [
        'clave',
        'remember_token',
    ];

    public function getAuthPassword()
    {
        return $this->clave;
    }
}
