<?php

namespace App\Http\Controllers\Configuracion;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use DataTables;
use Validator;

class RolesController extends Controller {

    public function __construct()
    {
        /*$this->middleware(function ($request, $next) {
            if (!Auth::user()->hasPermissionTo('roles')) {
                return response()->view('admin.errors.403', [
                    'modulo' => 'Roles y Permisos'
                ], 403);
            }

            return $next($request);
        });*/
    }

    public function index()
    {
        $roles = Role::all();
        $permisos = Permission::all();
        return view('configuracion.roles.index')
            ->with('roles', $roles)
            ->with('permisos', $permisos);
    }

    public function get()
    {
        $roles = Role::with('permissions')->get();
        return Datatables::of($roles)
            ->addIndexColumn()
            ->addColumn('permisos', function($rol) {
                $permisos = $rol->permissions->pluck('name')->toArray();
                return implode(', ', $permisos);
            })
            ->addColumn('Accion', function($rol){
                return "";
            })
            ->rawColumns(['action'])
            ->make(true);
    }

    public function create()
    {
        //return view('admin.configuracion.usuarios.create');
    }

    public function store(Request $request)
    {

        
        $validator = Validator::make($request->all(), [
            'rol' => 'required'
        ], []);
        
        if($validator->fails()){
            return response()->json([
                'error' => $validator->errors()->all()
            ]);  
        }

        $role = Role::create([
            'name' => $request->input('rol')
        ]);

        $role->syncPermissions($request->input('permissions'));

        return response()->json([
            'success' => true,
            'message' => 'Rol creado exitosamente'
        ]);
    }

    public function edit($id)
    {
        $role = Role::with('permissions')->find($id);
        return response()->json($role);
    }

    public function update(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'rol' => 'required'
        ], []);

        if($validator->fails()){
            return response()->json([
                'error' => $validator->errors()->all()
            ]);  
        }

        $role = Role::find($request->id);
        $role->name = $request->input('rol');
        $role->save();

        $role->syncPermissions($request->input('permissions'));

        return response()->json([
            'success' => true,
            'message' => 'Rol modificado exitosamente'
        ]);     
    }

    public function destroy($id)
    {

    }
}
